/* 
 *  SessionData.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.SessionI;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import java.util.LinkedList;
import java.util.List;
import javafx.util.Pair;

public class SessionData {

    private String lastLoginTime = "<NULL>";
    private String id = "<NULL>";
    private int numUsers = 0;
    private String version = "<NULL>";
    private boolean connected = false;

    private static final Logger LOG = Logger.getLogger(SessionData.class);

    public SessionData(SessionI session) {
        String methodName = "SessionData() ";
        if (session != null) {
            try {
                lastLoginTime = session.getLastLoginTime();
                id = session.getId();
                numUsers = session.getNumUsers();
                version = session.getVersion();
                connected = true;
            } catch (ObjectInvalidException ex) {
                LOG.error(methodName, "ObjectInvalidException while accessing session", ex);
                lastLoginTime = "<NULL>";
                id = "<NULL>";
                numUsers = 0;
                version = "<NULL>";
                connected = false;
            }
        }
    }
    
    public List<Pair<String, String>> getSessionProperties() {
        List<Pair<String, String>> sessionProperties = new LinkedList<>();
        sessionProperties.add(new Pair<String, String>("LastLoginTime", this.lastLoginTime));
        sessionProperties.add(new Pair<String, String>("Session ID", this.id));
        sessionProperties.add(new Pair<String, String>("Number of Users", String.valueOf(this.numUsers)));
        sessionProperties.add(new Pair<String, String>("Version", String.valueOf(this.version)));
        sessionProperties.add(new Pair<String, String>("Connected", String.valueOf(this.connected)));
        return sessionProperties;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String toString() {
        return "ID:" + id + " LastLoginTime:" + lastLoginTime + " NumUsers:" + numUsers + " Version:" + version
                + " Connected:" + connected;

    }
}
